﻿using inetsoftware.Config;
using inetsoftware.Reporting;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace inetsoftware
{
    /// <summary>
    /// This sample render a rpt file in the PDF format and write it to a file.
    /// </summary>
    public class SimpleExport
    {
        static SimpleExport()
        {
            // set license once from environment if required.
            string license = Environment.GetEnvironmentVariable("ICR_LICENSE");
            if (!string.IsNullOrEmpty(license))
            {
                ConfigurationManager.Instance.Current["licensekey"] = license;
            }
        }

        public static void Main(string[] args)
        {
            Engine eng = new Engine(Engine.EXPORT_PDF);
            eng.ReportFile = @"samples\resources\Sample.rpt";
            eng.Execute();

            int count = eng.PageCount;
            using (FileStream stream = new FileStream("Sample.pdf", FileMode.Create))
            {
                for (int i = 1; i <= count; i++)
                {
                    byte[] data = eng.PageData(i);
                    stream.Write(data, 0, data.Length);
                }
            }
        }
    }
}
